#delimit ;
cap log close ;
log using table3.log, text replace ;
set more off ;

cap log close t3out ;
qui log using table3_out.csv , text replace name(t3out) ;
qui log off t3out  ;

clear ;
clear mata ;
set seed 10101 ;
set matsize 10000 ;

run set_directory_macros ;
run t3_data_setup ;
run t3_ols ;
run t3_ar1 ;
run CR23_IK_CSS ;
run t34_programs ;

cap prog drop runme ;
prog def runme ;

local bsreps = 999 ;
local beta_hypothesis = 0 ;

tempfile main_data ;

/* get the dataset ready for estimation */
qui t3_setup , keylhs("lnwage_sy") sourcedata("${madedat}/CPS_panel") outdata(`main_data') ;


/* estimate "model 1" */
/* the t3_ols code will partial out state and year fixed effects */
t3_ols , bsreps(`bsreps') sourcedata(`main_data') lhs(lnwage_sy) rhs(policy) keyrhs(policy) ;


/* estimate "model 2" */
/* the t3_ols code will partial out state and year fixed effects */
t3_ols , bsreps(`bsreps') sourcedata(`main_data') lhs(lnwage_sy) rhs(policy) keyrhs(policy) yearonly ;


/* estimate "model 3" */
/* the t3_ar1 code does not partial out any fixed effects, so need to directly pass these in as regressors */
t3_ar1 , bsreps(`bsreps') sourcedata(`main_data') lhs(lnwage_sy) rhs(policy i.statefip i.year) keyrhs(policy) ;



end ;

runme ;

qui log close t3out ;
log close _all ;

